WebInspector.EditFileSystemView=function(fileSystemPath)
{WebInspector.VBox.call(this);this.registerRequiredCSS("settings/settingsScreen.css");this.element.classList.add("dialog-contents","settings-dialog","settings-tab");this._fileSystemPath=fileSystemPath;var contents=this.element.createChild("div","contents");WebInspector.fileSystemMapping.addEventListener(WebInspector.FileSystemMapping.Events.FileMappingAdded,this._fileMappingAdded,this);WebInspector.fileSystemMapping.addEventListener(WebInspector.FileSystemMapping.Events.FileMappingRemoved,this._fileMappingRemoved,this);WebInspector.isolatedFileSystemManager.addEventListener(WebInspector.IsolatedFileSystemManager.Events.ExcludedFolderAdded,this._excludedFolderAdded,this);WebInspector.isolatedFileSystemManager.addEventListener(WebInspector.IsolatedFileSystemManager.Events.ExcludedFolderRemoved,this._excludedFolderRemoved,this);var blockHeader=contents.createChild("div","block-header");blockHeader.textContent=WebInspector.UIString("Mappings");this._fileMappingsSection=contents.createChild("div","section");this._fileMappingsListContainer=this._fileMappingsSection.createChild("div","settings-list-container");var urlColumn={id:"url",placeholder:WebInspector.UIString("URL prefix")};var pathColumn={id:"path",placeholder:WebInspector.UIString("Folder path")};this._fileMappingsList=new WebInspector.EditableSettingsList([urlColumn,pathColumn],this._fileMappingValuesProvider.bind(this),this._fileMappingValidate.bind(this),this._fileMappingEdit.bind(this));this._fileMappingsList.addEventListener(WebInspector.SettingsList.Events.Removed,this._fileMappingRemovedfromList.bind(this));this._fileMappingsList.element.classList.add("file-mappings-list");this._fileMappingsListContainer.appendChild(this._fileMappingsList.element);this._entries={};var entries=WebInspector.fileSystemMapping.mappingEntries(this._fileSystemPath);for(var entry of entries){if(!entry.configurable)
this._addMappingRow(entry);}
for(var entry of entries){if(entry.configurable)
this._addMappingRow(entry);}
blockHeader=contents.createChild("div","block-header excluded-folders-header");blockHeader.textContent=WebInspector.UIString("Excluded folders");this._excludedFolderListSection=contents.createChild("div","section excluded-folders-section");this._excludedFolderListContainer=this._excludedFolderListSection.createChild("div","settings-list-container");this._excludedFolderList=new WebInspector.EditableSettingsList([pathColumn],this._excludedFolderValueProvider.bind(this),this._excludedFolderValidate.bind(this),this._excludedFolderEdit.bind(this));this._excludedFolderList.addEventListener(WebInspector.SettingsList.Events.Removed,this._excludedFolderRemovedfromList.bind(this));this._excludedFolderList.element.classList.add("excluded-folders-list");this._excludedFolderListContainer.appendChild(this._excludedFolderList.element);this._excludedFolderEntries=new Set();for(var folder of WebInspector.isolatedFileSystemManager.fileSystem(fileSystemPath).nonConfigurableExcludedFolders().values())
this._addExcludedFolderRow(folder,true);for(var folder of WebInspector.isolatedFileSystemManager.fileSystem(fileSystemPath).excludedFolders().values())
this._addExcludedFolderRow(folder,false);this.element.tabIndex=0;this._hasMappingChanges=false;}
WebInspector.EditFileSystemView.prototype={dispose:function()
{WebInspector.fileSystemMapping.removeEventListener(WebInspector.FileSystemMapping.Events.FileMappingAdded,this._fileMappingAdded,this);WebInspector.fileSystemMapping.removeEventListener(WebInspector.FileSystemMapping.Events.FileMappingRemoved,this._fileMappingRemoved,this);WebInspector.isolatedFileSystemManager.removeEventListener(WebInspector.IsolatedFileSystemManager.Events.ExcludedFolderAdded,this._excludedFolderAdded,this);WebInspector.isolatedFileSystemManager.removeEventListener(WebInspector.IsolatedFileSystemManager.Events.ExcludedFolderRemoved,this._excludedFolderRemoved,this);},_fileMappingAdded:function(event)
{var entry=(event.data);this._addMappingRow(entry);},_fileMappingRemoved:function(event)
{var entry=(event.data);if(this._fileSystemPath!==entry.fileSystemPath)
return;var key=this._entryKey(entry);delete this._entries[key];if(this._fileMappingsList.itemForId(key))
this._fileMappingsList.removeItem(key);},_entryKey:function(entry)
{return(entry.configurable?"configurable:":"nonconfigurable:")+entry.urlPrefix;},_fileMappingValuesProvider:function(itemId,columnId)
{if(!itemId)
return"";var entry=this._entries[itemId];switch(columnId){case"url":return entry.configurable?entry.urlPrefix:WebInspector.UIString("%s (via .devtools)",entry.urlPrefix);case"path":return entry.pathPrefix;default:console.assert("Should not be reached.");}
return"";},_fileMappingValidate:function(itemId,data)
{var oldPathPrefix=itemId?this._entries[itemId].pathPrefix:null;var oldURLPrefix=itemId?this._entries[itemId].urlPrefix:null;return this._validateMapping(data["url"],oldURLPrefix,data["path"],oldPathPrefix);},_fileMappingEdit:function(itemId,data)
{if(itemId){var urlPrefix=itemId;var pathPrefix=this._entries[itemId].pathPrefix;var fileSystemPath=this._entries[itemId].fileSystemPath;WebInspector.fileSystemMapping.removeFileMapping(fileSystemPath,urlPrefix,pathPrefix);}
this._addFileMapping(data["url"],data["path"]);},_validateMapping:function(urlPrefix,allowedURLPrefix,path,allowedPathPrefix)
{var columns=[];if(!this._checkURLPrefix(urlPrefix,allowedURLPrefix))
columns.push("url");if(!this._checkPathPrefix(path,allowedPathPrefix))
columns.push("path");return columns;},_fileMappingRemovedfromList:function(event)
{var urlPrefix=(event.data);if(!urlPrefix)
return;var entry=this._entries[urlPrefix];WebInspector.fileSystemMapping.removeFileMapping(entry.fileSystemPath,entry.urlPrefix,entry.pathPrefix);this._hasMappingChanges=true;},_addFileMapping:function(urlPrefix,pathPrefix)
{var normalizedURLPrefix=this._normalizePrefix(urlPrefix);var normalizedPathPrefix=this._normalizePrefix(pathPrefix);WebInspector.fileSystemMapping.addFileMapping(this._fileSystemPath,normalizedURLPrefix,normalizedPathPrefix);this._hasMappingChanges=true;this._fileMappingsList.selectItem("configurable:"+normalizedURLPrefix);return true;},_normalizePrefix:function(prefix)
{if(!prefix)
return"";return prefix+(prefix[prefix.length-1]==="/"?"":"/");},_addMappingRow:function(entry)
{var key=this._entryKey(entry);if(this._fileMappingsList.itemForId(key))
return;var fileSystemPath=entry.fileSystemPath;if(!this._fileSystemPath||this._fileSystemPath!==fileSystemPath)
return;this._entries[key]=entry;var keys=Object.keys(this._entries).sort();this._fileMappingsList.addItem(key,keys[keys.indexOf(key)+1],!entry.configurable);},_excludedFolderAdded:function(event)
{var path=(event.data);this._addExcludedFolderRow(path,false);},_excludedFolderRemoved:function(event)
{var path=(event.data);delete this._excludedFolderEntries[path];if(this._excludedFolderList.itemForId(path))
this._excludedFolderList.removeItem(path);},_excludedFolderValueProvider:function(itemId,columnId)
{return itemId;},_excludedFolderValidate:function(itemId,data)
{var columns=[];if(!this._validateExcludedFolder(data["path"],itemId))
columns.push("path");return columns;},_validateExcludedFolder:function(path,allowedPath)
{return!!path&&(path===allowedPath||!this._excludedFolderEntries.has(path));},_excludedFolderEdit:function(itemId,data)
{if(itemId)
WebInspector.isolatedFileSystemManager.fileSystem(this._fileSystemPath).removeExcludedFolder(itemId);var excludedFolderPath=data["path"];WebInspector.isolatedFileSystemManager.fileSystem(this._fileSystemPath).addExcludedFolder(excludedFolderPath);},_excludedFolderRemovedfromList:function(event)
{var itemId=(event.data);if(!itemId)
return;WebInspector.isolatedFileSystemManager.fileSystem(this._fileSystemPath).removeExcludedFolder(itemId);},_addExcludedFolderRow:function(path,readOnly)
{if(this._excludedFolderEntries.has(path))
return;this._excludedFolderEntries.add(path);if(readOnly&&!this._firstNonConfigurableExcludedFolder)
this._firstNonConfigurableExcludedFolder=WebInspector.UIString("%s (via .devtools)",path);var insertBefore=readOnly?null:this._firstNonConfigurableExcludedFolder;this._excludedFolderList.addItem(readOnly?WebInspector.UIString("%s (via .devtools)",path):path,insertBefore,readOnly);},_checkURLPrefix:function(value,allowedPrefix)
{var prefix=this._normalizePrefix(value);return!!prefix&&(prefix===allowedPrefix||!this._entries["configurable:"+prefix]);},_checkPathPrefix:function(value,allowedPrefix)
{var prefix=this._normalizePrefix(value);if(!prefix)
return false;if(prefix===allowedPrefix)
return true;for(var key in this._entries){var entry=this._entries[key];if(entry.configurable&&entry.pathPrefix===prefix)
return false;}
return true;},__proto__:WebInspector.VBox.prototype};WebInspector.SettingsScreen=function()
{WebInspector.VBox.call(this,true);this.registerRequiredCSS("settings/settingsScreen.css");this.element.id="settings-screen";this.contentElement.tabIndex=0;this.contentElement.classList.add("help-window-main");this.contentElement.classList.add("vbox");var settingsLabelElement=createElementWithClass("div","help-window-label");settingsLabelElement.createTextChild(WebInspector.UIString("Settings"));this._tabbedPane=new WebInspector.TabbedPane();this._tabbedPane.insertBeforeTabStrip(settingsLabelElement);this._tabbedPane.setShrinkableTabs(false);this._tabbedPane.setVerticalTabLayout(true);this._tabbedPane.appendTab("general",WebInspector.UIString("General"),new WebInspector.GenericSettingsTab());this._tabbedPane.appendTab("workspace",WebInspector.UIString("Workspace"),new WebInspector.WorkspaceSettingsTab());this._tabbedPane.appendTab("blackbox",WebInspector.manageBlackboxingSettingsTabLabel(),new WebInspector.FrameworkBlackboxSettingsTab());if(Runtime.experiments.supportEnabled())
this._tabbedPane.appendTab("experiments",WebInspector.UIString("Experiments"),new WebInspector.ExperimentsSettingsTab());this._tabbedPaneController=new WebInspector.ExtensibleTabbedPaneController(this._tabbedPane,"settings-view");this._tabbedPane.appendTab("shortcuts",WebInspector.UIString("Shortcuts"),WebInspector.shortcutsScreen.createShortcutsTabView());this.element.addEventListener("keydown",this._keyDown.bind(this),false);this._developerModeCounter=0;this.setDefaultFocusedElement(this.contentElement);}
WebInspector.SettingsScreen.prototype={wasShown:function()
{this._tabbedPane.selectTab("general");this._tabbedPane.show(this.contentElement);WebInspector.VBox.prototype.wasShown.call(this);},selectTab:function(name)
{this._tabbedPane.selectTab(name);},_keyDown:function(event)
{var shiftKeyCode=16;if(event.keyCode===shiftKeyCode&&++this._developerModeCounter>5)
this.contentElement.classList.add("settings-developer-mode");},__proto__:WebInspector.VBox.prototype}
WebInspector.SettingsTab=function(name,id)
{WebInspector.VBox.call(this);this.element.classList.add("settings-tab-container");if(id)
this.element.id=id;var header=this.element.createChild("header");header.createChild("h3").createTextChild(name);this.containerElement=this.element.createChild("div","help-container-wrapper").createChild("div","settings-tab help-content help-container");}
WebInspector.SettingsTab.prototype={_appendSection:function(name)
{var block=this.containerElement.createChild("div","help-block");if(name)
block.createChild("div","help-section-title").textContent=name;return block;},_createSelectSetting:function(name,options,setting)
{var p=createElement("p");p.createChild("label").textContent=name;var select=p.createChild("select","chrome-select");var settingValue=setting.get();for(var i=0;i<options.length;++i){var option=options[i];select.add(new Option(option[0],option[1]));if(settingValue===option[1])
select.selectedIndex=i;}
function changeListener(e)
{setting.set(options[select.selectedIndex][1]);}
select.addEventListener("change",changeListener,false);return p;},__proto__:WebInspector.VBox.prototype}
WebInspector.GenericSettingsTab=function()
{WebInspector.SettingsTab.call(this,WebInspector.UIString("General"),"general-tab-content");var explicitSectionOrder=["","Appearance","Elements","Sources","Network","Profiler","Console","Extensions"];this._nameToSection=new Map();this._nameToSettingElement=new Map();for(var sectionName of explicitSectionOrder)
this._sectionElement(sectionName);self.runtime.extensions("setting").forEach(this._addSetting.bind(this));self.runtime.extensions(WebInspector.SettingUI).forEach(this._addSettingUI.bind(this));this._appendSection().appendChild(createTextButton(WebInspector.UIString("Restore defaults and reload"),restoreAndReload));function restoreAndReload()
{WebInspector.settings.clearAll();WebInspector.reload();}}
WebInspector.GenericSettingsTab.isSettingVisible=function(extension)
{var descriptor=extension.descriptor();if(!("title"in descriptor))
return false;if(!(("category"in descriptor)||("parentSettingName"in descriptor)))
return false;return true;}
WebInspector.GenericSettingsTab.prototype={_addSetting:function(extension)
{if(!WebInspector.GenericSettingsTab.isSettingVisible(extension))
return;var descriptor=extension.descriptor();var sectionName=descriptor["category"];var settingName=descriptor["settingName"];var setting=WebInspector.moduleSetting(settingName);var uiTitle=WebInspector.UIString(extension.title(WebInspector.platform()));var sectionElement=this._sectionElement(sectionName);var parentSettingName=descriptor["parentSettingName"];var parentSettingElement=parentSettingName?this._nameToSettingElement.get(descriptor["parentSettingName"]):null;var parentFieldset=null;if(parentSettingElement){parentFieldset=parentSettingElement.__fieldset;if(!parentFieldset){parentFieldset=WebInspector.SettingsUI.createSettingFieldset(WebInspector.moduleSetting(parentSettingName));parentSettingElement.appendChild(parentFieldset);parentSettingElement.__fieldset=parentFieldset;}}
var settingControl;switch(descriptor["settingType"]){case"boolean":settingControl=WebInspector.SettingsUI.createSettingCheckbox(uiTitle,setting);break;case"enum":var descriptorOptions=descriptor["options"];var options=new Array(descriptorOptions.length);for(var i=0;i<options.length;++i){var optionName=descriptorOptions[i][2]?descriptorOptions[i][0]:WebInspector.UIString(descriptorOptions[i][0]);options[i]=[optionName,descriptorOptions[i][1]];}
settingControl=this._createSelectSetting(uiTitle,options,setting);break;default:console.error("Invalid setting type: "+descriptor["settingType"]);return;}
this._nameToSettingElement.set(settingName,settingControl);(parentFieldset||sectionElement).appendChild((settingControl));},_addSettingUI:function(extension)
{var descriptor=extension.descriptor();var sectionName=descriptor["category"]||"";extension.instancePromise().then(appendCustomSetting.bind(this));function appendCustomSetting(object)
{var settingUI=(object);var element=settingUI.settingElement();if(element)
this._sectionElement(sectionName).appendChild(element);}},_sectionElement:function(sectionName)
{var sectionElement=this._nameToSection.get(sectionName);if(!sectionElement){var uiSectionName=sectionName&&WebInspector.UIString(sectionName);sectionElement=this._appendSection(uiSectionName);this._nameToSection.set(sectionName,sectionElement);}
return sectionElement;},__proto__:WebInspector.SettingsTab.prototype}
WebInspector.WorkspaceSettingsTab=function()
{WebInspector.SettingsTab.call(this,WebInspector.UIString("Workspace"),"workspace-tab-content");WebInspector.isolatedFileSystemManager.addEventListener(WebInspector.IsolatedFileSystemManager.Events.FileSystemAdded,this._fileSystemAdded,this);WebInspector.isolatedFileSystemManager.addEventListener(WebInspector.IsolatedFileSystemManager.Events.FileSystemRemoved,this._fileSystemRemoved,this);this._commonSection=this._appendSection(WebInspector.UIString("Common"));var folderExcludeSetting=WebInspector.isolatedFileSystemManager.workspaceFolderExcludePatternSetting();var folderExcludePatternInput=WebInspector.SettingsUI.createSettingInputField(WebInspector.UIString("Folder exclude pattern"),folderExcludeSetting,false,0,"270px",WebInspector.SettingsUI.regexValidator);this._commonSection.appendChild(folderExcludePatternInput);this._fileSystemsSection=this._appendSection(WebInspector.UIString("Folders"));this._fileSystemsListContainer=this._fileSystemsSection.createChild("p","settings-list-container");this._addFileSystemRowElement=this._fileSystemsSection.createChild("div");this._addFileSystemRowElement.appendChild(createTextButton(WebInspector.UIString("Add folder\u2026"),this._addFileSystemClicked.bind(this)));this._elementByPath=new Map();this._mappingViewByPath=new Map();var fileSystemPaths=WebInspector.isolatedFileSystemManager.fileSystemPaths();for(var i=0;i<fileSystemPaths.length;++i)
this._addItem((WebInspector.isolatedFileSystemManager.fileSystem(fileSystemPaths[i])));}
WebInspector.WorkspaceSettingsTab.prototype={_addItem:function(fileSystem)
{var element=this._renderFileSystem(fileSystem);this._elementByPath.set(fileSystem.path(),element);this._fileSystemsListContainer.appendChild(element);var mappingView=new WebInspector.EditFileSystemView(fileSystem.path());this._mappingViewByPath.set(fileSystem.path(),mappingView);mappingView.show(element);},_renderFileSystem:function(fileSystem)
{var element=createElementWithClass("div","file-system-container");var fileSystemPath=fileSystem.path();var textElement=element.createChild("div","file-system-header");var pathElement=textElement.createChild("div","file-system-path");pathElement.title=fileSystemPath;const maxTotalPathLength=75;const maxFolderNameLength=40;var lastIndexOfSlash=fileSystemPath.lastIndexOf(WebInspector.isWin()?"\\":"/");var folderName=fileSystemPath.substr(lastIndexOfSlash+1);var folderPath=fileSystemPath.substr(0,lastIndexOfSlash+1);folderPath=folderPath.trimMiddle(maxTotalPathLength-Math.min(maxFolderNameLength,folderName.length));folderName=folderName.trimMiddle(maxFolderNameLength);pathElement.createChild("span").textContent=WebInspector.UIString("Folder: ");var folderPathElement=pathElement.createChild("span");folderPathElement.textContent=folderPath;var nameElement=pathElement.createChild("span","file-system-path-name");nameElement.textContent=folderName;textElement.appendChild(createTextButton(WebInspector.UIString("Remove"),this._removeFileSystemClicked.bind(this,fileSystem)));return element;},_removeFileSystemClicked:function(fileSystem)
{WebInspector.isolatedFileSystemManager.removeFileSystem(fileSystem.path());},_addFileSystemClicked:function()
{WebInspector.isolatedFileSystemManager.addFileSystem("");},_fileSystemAdded:function(event)
{var fileSystem=(event.data);this._addItem(fileSystem);},_fileSystemRemoved:function(event)
{var fileSystem=(event.data);var mappingView=this._mappingViewByPath.get(fileSystem.path());if(mappingView){mappingView.dispose();this._mappingViewByPath.delete(fileSystem.path());}
var element=this._elementByPath.get(fileSystem.path());if(element){this._elementByPath.delete(fileSystem.path());element.remove();}},__proto__:WebInspector.SettingsTab.prototype}
WebInspector.ExperimentsSettingsTab=function()
{WebInspector.SettingsTab.call(this,WebInspector.UIString("Experiments"),"experiments-tab-content");var experiments=Runtime.experiments.allConfigurableExperiments();if(experiments.length){var experimentsSection=this._appendSection();experimentsSection.appendChild(this._createExperimentsWarningSubsection());for(var i=0;i<experiments.length;++i)
experimentsSection.appendChild(this._createExperimentCheckbox(experiments[i]));}}
WebInspector.ExperimentsSettingsTab.prototype={_createExperimentsWarningSubsection:function()
{var subsection=createElement("div");var warning=subsection.createChild("span","settings-experiments-warning-subsection-warning");warning.textContent=WebInspector.UIString("WARNING:");subsection.createTextChild(" ");var message=subsection.createChild("span","settings-experiments-warning-subsection-message");message.textContent=WebInspector.UIString("These experiments could be dangerous and may require restart.");return subsection;},_createExperimentCheckbox:function(experiment)
{var label=createCheckboxLabel(WebInspector.UIString(experiment.title),experiment.isEnabled());var input=label.checkboxElement;input.name=experiment.name;function listener()
{experiment.setEnabled(input.checked);}
input.addEventListener("click",listener,false);var p=createElement("p");p.className=experiment.hidden&&!experiment.isEnabled()?"settings-experiment-hidden":"";p.appendChild(label);return p;},__proto__:WebInspector.SettingsTab.prototype}
WebInspector.SettingsController=function()
{this._settingsScreen;}
WebInspector.SettingsController.prototype={showSettingsScreen:function(name)
{if(!this._settingsScreen)
this._settingsScreen=new WebInspector.SettingsScreen();var dialog=new WebInspector.Dialog();dialog.addCloseButton();this._settingsScreen.show(dialog.element);dialog.show();if(name)
this._settingsScreen.selectTab(name);}}
WebInspector.SettingsController.ActionDelegate=function(){}
WebInspector.SettingsController.ActionDelegate.prototype={handleAction:function(context,actionId)
{switch(actionId){case"settings.show":WebInspector._settingsController.showSettingsScreen();return true;case"settings.help":InspectorFrontendHost.openInNewTab("https://developers.google.com/web/tools/chrome-devtools/");return true;case"settings.shortcuts":WebInspector._settingsController.showSettingsScreen("shortcuts");return true;}
return false;}}
WebInspector.SettingsController.Revealer=function(){}
WebInspector.SettingsController.Revealer.prototype={reveal:function(object,lineNumber)
{console.assert(object instanceof WebInspector.Setting);var setting=(object);var success=false;self.runtime.extensions("setting").forEach(revealModuleSetting);self.runtime.extensions(WebInspector.SettingUI).forEach(revealSettingUI);self.runtime.extensions("settings-view").forEach(revealSettingsView);return success?Promise.resolve():Promise.reject();function revealModuleSetting(extension)
{if(!WebInspector.GenericSettingsTab.isSettingVisible(extension))
return;if(extension.descriptor()["settingName"]===setting.name){WebInspector._settingsController.showSettingsScreen("general");success=true;}}
function revealSettingUI(extension)
{var settings=extension.descriptor()["settings"];if(settings&&settings.indexOf(setting.name)!==-1){WebInspector._settingsController.showSettingsScreen("general");success=true;}}
function revealSettingsView(extension)
{var settings=extension.descriptor()["settings"];if(settings&&settings.indexOf(setting.name)!==-1){WebInspector._settingsController.showSettingsScreen(extension.descriptor()["name"]);success=true;}}}}
WebInspector.SettingsList=function(columns,itemRenderer)
{this.element=createElementWithClass("div","settings-list");this.element.tabIndex=-1;this._itemRenderer=itemRenderer;this._listItems=new Map();this._ids=[];this._columns=columns;this._editableEntries=new Set();}
WebInspector.SettingsList.Events={Selected:"Selected",Removed:"Removed",DoubleClicked:"DoubleClicked",}
WebInspector.SettingsList.prototype={addItem:function(itemId,beforeId,readOnly)
{if(!readOnly&&itemId)
this._editableEntries.add(itemId);var listItem=createElementWithClass("div","settings-list-item");listItem._id=itemId;if(beforeId)
this.element.insertBefore(listItem,this.itemForId(beforeId));else
this.element.appendChild(listItem);var listItemContents=listItem.createChild("div","settings-list-item-contents");var listItemColumnsElement=listItemContents.createChild("div","settings-list-item-columns");listItem.columnElements={};for(var i=0;i<this._columns.length;++i){var column=this._columns[i];var columnElement=listItemColumnsElement.createChild("div","list-column settings-list-column-"+column.id);listItem.columnElements[column.id]=columnElement;this._itemRenderer(columnElement,column,itemId);}
if(!readOnly){var removeItemButton=this._createRemoveButton(removeItemClicked.bind(this));listItemContents.addEventListener("click",this.selectItem.bind(this,itemId),false);listItemContents.addEventListener("dblclick",this._onDoubleClick.bind(this,itemId),false);listItemContents.appendChild(removeItemButton);}
this._listItems.set(itemId||"",listItem);if(typeof beforeId!=="undefined")
this._ids.splice(this._ids.indexOf(beforeId),0,itemId);else
this._ids.push(itemId);function removeItemClicked(event)
{removeItemButton.disabled=true;this.removeItem(itemId);this.dispatchEventToListeners(WebInspector.SettingsList.Events.Removed,itemId);event.consume();}
return listItem;},removeItem:function(id)
{var listItem=this._listItems.remove(id||"");if(listItem)
listItem.remove();this._ids.remove(id);if(id===this._selectedId){delete this._selectedId;if(this._ids.length)
this.selectItem(this._ids[0]);}},itemIds:function()
{return this._ids.slice();},columns:function()
{return this._columns.select("id");},selectedId:function()
{return this._selectedId;},selectedItem:function()
{return this._selectedId?this.itemForId(this._selectedId):null;},itemForId:function(itemId)
{return this._listItems.get(itemId)||null;},_onDoubleClick:function(id,event)
{this.dispatchEventToListeners(WebInspector.SettingsList.Events.DoubleClicked,id);},selectItem:function(id,event)
{if(this._selectedId)
this.itemForId(this._selectedId).classList.remove("selected");this._selectedId=id;if(this._selectedId)
this.itemForId(this._selectedId).classList.add("selected");this.dispatchEventToListeners(WebInspector.SettingsList.Events.Selected,id);if(event)
event.consume();},_createRemoveButton:function(handler)
{var removeButton=createElementWithClass("div","remove-item-button");removeButton.addEventListener("click",handler,false);return removeButton;},__proto__:WebInspector.Object.prototype}
WebInspector.EditableSettingsList=function(columns,valuesProvider,validateHandler,editHandler)
{WebInspector.SettingsList.call(this,columns,this._renderColumn.bind(this));this._valuesProvider=valuesProvider;this._validateHandler=validateHandler;this._editHandler=editHandler;this._addInputElements=new Map();this._editInputElements=new Map();this._textElements=new Map();this._addMappingItem=this.addItem(null);this._addMappingItem.classList.add("item-editing","add-list-item");}
WebInspector.EditableSettingsList.prototype={addItem:function(itemId,beforeId,readOnly)
{var listItem=WebInspector.SettingsList.prototype.addItem.call(this,itemId,beforeId,readOnly);if(!readOnly)
listItem.classList.add("editable");return listItem;},refreshItem:function(itemId)
{if(!itemId)
return;var listItem=this.itemForId(itemId);if(!listItem)
return;for(var i=0;i<this._columns.length;++i){var column=this._columns[i];var columnId=column.id;var value=this._valuesProvider(itemId,columnId);this._setTextElementContent(itemId,columnId,value);var editElement=this._editInputElements.get(itemId).get(columnId);this._setEditElementValue(editElement,value||"");}},_textElementContent:function(itemId,columnId)
{if(!itemId)
return"";return this._textElements.get(itemId).get(columnId).textContent.replace(/\u200B/g,"");},_setTextElementContent:function(itemId,columnId,text)
{var textElement=this._textElements.get(itemId).get(columnId);textElement.textContent=text.replace(/.{4}/g,"$&\u200B");textElement.title=text;},_renderColumn:function(columnElement,column,itemId)
{var columnId=column.id;if(itemId===null){this._createEditElement(columnElement,column,itemId);return;}
var validItemId=itemId;if(!this._editInputElements.has(itemId))
this._editInputElements.set(itemId,new Map());if(!this._textElements.has(itemId))
this._textElements.set(itemId,new Map());var value=this._valuesProvider(itemId,columnId);var textElement=(columnElement.createChild("span","list-column-text"));if(this._editableEntries.has(itemId))
columnElement.addEventListener("click",rowClicked.bind(this),false);this._textElements.get(itemId).set(columnId,textElement);this._setTextElementContent(itemId,columnId,value);if(this._editableEntries.has(itemId))
this._createEditElement(columnElement,column,itemId,value);function rowClicked(event)
{if(itemId===this._editingId)
return;console.assert(!this._editingId);this._editingId=validItemId;var listItem=this.itemForId(validItemId);listItem.classList.add("item-editing");var editElement=event.target.editElement||this._editInputElements.get(validItemId).get(this.columns()[0]);editElement.focus();if(editElement.select)
editElement.select();}},_createEditElement:function(columnElement,column,itemId,value)
{var options=column.options;if(options){var editElement=(columnElement.createChild("select","chrome-select list-column-editor"));for(var i=0;i<options.length;++i){var option=editElement.createChild("option");option.value=options[i];option.textContent=options[i];}
editElement.addEventListener("blur",this._editMappingBlur.bind(this,itemId),false);editElement.addEventListener("change",this._editMappingBlur.bind(this,itemId),false);}else{var editElement=(columnElement.createChild("input","list-column-editor"));editElement.addEventListener("blur",this._editMappingBlur.bind(this,itemId),false);editElement.addEventListener("input",this._validateEdit.bind(this,itemId),false);if(itemId===null)
editElement.placeholder=column.placeholder||"";}
if(itemId===null)
this._addInputElements.set(column.id,editElement);else
this._editInputElements.get(itemId).set(column.id,editElement);this._setEditElementValue(editElement,value||"");columnElement.editElement=editElement;return editElement;},_setEditElementValue:function(editElement,value)
{if(!editElement)
return;if(editElement instanceof HTMLSelectElement){var options=editElement.options;for(var i=0;i<options.length;++i)
options[i].selected=(options[i].value===value);}else{editElement.value=value;}},_data:function(itemId)
{var inputElements=this._inputElements(itemId);var data={__proto__:null};var columns=this.columns();for(var i=0;i<columns.length;++i)
data[columns[i]]=inputElements.get(columns[i]).value;return data;},_inputElements:function(itemId)
{if(!itemId)
return this._addInputElements;return this._editInputElements.get(itemId)||null;},_validateEdit:function(itemId)
{var errorColumns=this._validateHandler(itemId,this._data(itemId));var hasChanges=this._hasChanges(itemId);var columns=this.columns();for(var i=0;i<columns.length;++i){var columnId=columns[i];var inputElement=this._inputElements(itemId).get(columnId);if(hasChanges&&errorColumns.indexOf(columnId)!==-1)
inputElement.classList.add("editable-item-error");else
inputElement.classList.remove("editable-item-error");}
return!errorColumns.length;},_hasChanges:function(itemId)
{var columns=this.columns();for(var i=0;i<columns.length;++i){var columnId=columns[i];var oldValue=this._textElementContent(itemId,columnId);var newValue=this._inputElements(itemId).get(columnId).value;if(oldValue!==newValue)
return true;}
return false;},_editMappingBlur:function(itemId,event)
{if(itemId===null){this._onAddMappingInputBlur(event);return;}
var inputElements=this._editInputElements.get(itemId).valuesArray();if(inputElements.indexOf(event.relatedTarget)!==-1)
return;var listItem=this.itemForId(itemId);listItem.classList.remove("item-editing");delete this._editingId;if(!this._hasChanges(itemId))
return;if(!this._validateEdit(itemId)){var columns=this.columns();for(var i=0;i<columns.length;++i){var columnId=columns[i];var editElement=this._editInputElements.get(itemId).get(columnId);this._setEditElementValue(editElement,this._textElementContent(itemId,columnId));editElement.classList.remove("editable-item-error");}
return;}
this._editHandler(itemId,this._data(itemId));},_onAddMappingInputBlur:function(event)
{var inputElements=this._addInputElements.valuesArray();if(inputElements.indexOf(event.relatedTarget)!==-1)
return;if(!this._hasChanges(null))
return;if(!this._validateEdit(null))
return;this._editHandler(null,this._data(null));var columns=this.columns();for(var i=0;i<columns.length;++i){var columnId=columns[i];var editElement=this._addInputElements.get(columnId);this._setEditElementValue(editElement,"");}},__proto__:WebInspector.SettingsList.prototype}
WebInspector._settingsController=new WebInspector.SettingsController();;WebInspector.FrameworkBlackboxSettingsTab=function()
{WebInspector.SettingsTab.call(this,WebInspector.UIString("Framework Blackbox Patterns"));this.containerElement.classList.add("blackbox-dialog","dialog-contents","settings-dialog","settings-tab");this.registerRequiredCSS("settings/settingsScreen.css");var contents=this.containerElement.createChild("div","contents");var contentScriptsSection=contents.createChild("div","blackbox-content-scripts");contentScriptsSection.appendChild(WebInspector.SettingsUI.createSettingCheckbox(WebInspector.UIString("Blackbox content scripts"),WebInspector.moduleSetting("skipContentScripts"),true));var blockHeader=contents.createChild("div","columns-header");blockHeader.createChild("span").textContent=WebInspector.UIString("URI pattern");blockHeader.createChild("span").textContent=WebInspector.UIString("Behavior");var section=contents.createChild("div","section");var container=section.createChild("div","settings-list-container");this._blackboxLabel=WebInspector.UIString("Blackbox");this._disabledLabel=WebInspector.UIString("Disabled");var column1={id:"pattern",placeholder:"/framework\\.js$"};var column2={id:"value",options:[this._blackboxLabel,this._disabledLabel]};this._patternsList=new WebInspector.EditableSettingsList([column1,column2],this._patternValuesProvider.bind(this),this._patternValidate.bind(this),this._patternEdit.bind(this));this._patternsList.element.classList.add("blackbox-patterns-list");this._patternsList.addEventListener(WebInspector.SettingsList.Events.Removed,this._patternRemovedFromList.bind(this));container.appendChild(this._patternsList.element);this._entries=new Map();var patterns=WebInspector.moduleSetting("skipStackFramesPattern").getAsArray();for(var i=0;i<patterns.length;++i)
this._addPattern(patterns[i].pattern,patterns[i].disabled);this.containerElement.tabIndex=0;}
WebInspector.FrameworkBlackboxSettingsTab.prototype={_patternValuesProvider:function(itemId,columnId)
{if(!itemId)
return"";switch(columnId){case"pattern":return itemId;case"value":return(this._entries.get(itemId));default:console.assert("Should not be reached.");}
return"";},_patternValidate:function(itemId,data)
{var regex;var oldPattern=itemId;var newPattern=data["pattern"];try{if(newPattern&&(oldPattern===newPattern||!this._entries.has(newPattern)))
regex=new RegExp(newPattern);}catch(e){}
return regex?[]:["pattern"];},_patternEdit:function(itemId,data)
{var oldPattern=itemId;var newPattern=data["pattern"];if(!newPattern)
return;var disabled=(data["value"]===this._disabledLabel);var patterns=WebInspector.moduleSetting("skipStackFramesPattern").getAsArray();for(var i=0;i<=patterns.length;++i){if(i===patterns.length){patterns.push({pattern:newPattern,disabled:disabled});break;}
if(patterns[i].pattern===oldPattern){patterns[i]={pattern:newPattern,disabled:disabled};break;}}
WebInspector.moduleSetting("skipStackFramesPattern").setAsArray(patterns);if(oldPattern&&oldPattern===newPattern){this._entries.set(newPattern,disabled?this._disabledLabel:this._blackboxLabel);this._patternsList.itemForId(oldPattern).classList.toggle("disabled",disabled);this._patternsList.refreshItem(newPattern);return;}
if(oldPattern){this._patternsList.removeItem(oldPattern);this._entries.remove(oldPattern);}
this._addPattern(newPattern,disabled);},_patternRemovedFromList:function(event)
{var pattern=(event.data);if(!pattern)
return;this._entries.remove(pattern);var patterns=WebInspector.moduleSetting("skipStackFramesPattern").getAsArray();for(var i=0;i<patterns.length;++i){if(patterns[i].pattern===pattern){patterns.splice(i,1);break;}}
WebInspector.moduleSetting("skipStackFramesPattern").setAsArray(patterns);},_addPattern:function(pattern,disabled)
{if(!pattern||this._entries.has(pattern))
return;this._entries.set(pattern,disabled?this._disabledLabel:this._blackboxLabel);var listItem=this._patternsList.addItem(pattern,null);listItem.classList.toggle("disabled",disabled);},__proto__:WebInspector.SettingsTab.prototype};Runtime.cachedResources["settings/settingsScreen.css"]="/*\n * Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.help-window-main {\n    color: rgb(48, 57, 66);\n    background-color: white;\n    padding: 11px 0 0 0;\n}\n\n.help-window-caption {\n    border-bottom: solid 1px rgb(153, 153, 153);\n    margin: 0 8px;\n    padding: 0 2px;\n    line-height: 28px;\n}\n\n.help-content {\n    overflow-y: auto;\n    overflow-x: hidden;\n    margin: 8px 8px 8px 0;\n    padding: 0 4px;\n    flex: auto;\n}\n\n.help-footnote {\n    border-top: 1px solid #EEEEEE;\n    margin: 0;\n    padding: 12px;\n}\n\n.help-window-main .help-container-wrapper::-webkit-scrollbar {\n    width: 11px;\n}\n\n.help-window-main .help-container-wrapper::-webkit-scrollbar-corner,\n.help-window-main .help-container-wrapper::-webkit-resizer {\n    display: none;\n}\n\n.help-window-main .help-container-wrapper::-webkit-scrollbar-thumb:vertical {\n    background: linear-gradient(to right, rgb(128, 128, 128), rgb(96, 96, 96) 40%, rgb(128, 128, 128));\n    border-radius: 5px;\n    min-height: 20px;\n}\n\n.help-window-main .help-container-wrapper::-webkit-scrollbar-thumb:vertical:hover,\n.help-window-main .help-container-wrapper::-webkit-scrollbar-thumb:vertical:active {\n    background: linear-gradient(to right, rgb(176, 176, 176), rgb(144, 144, 144) 40%, rgb(176, 176, 176));\n}\n\n.help-window-main .help-container-wrapper::-webkit-scrollbar-track:vertical {\n    background: linear-gradient(to right, rgb(10, 10, 10), rgb(32, 32, 32) 25%, rgb(32, 32, 32));\n    border-radius: 5px;\n}\n\n.help-container {\n    width: 100%;\n    -webkit-user-select: auto;\n    -webkit-column-width: 288px;\n}\n\n.help-no-columns {\n    -webkit-column-width: initial !important;\n}\n\n.help-block {\n    display: block;\n    padding-bottom: 9px;\n    width: 288px;\n    -webkit-column-break-inside: avoid;\n}\n\n.settings-tab.help-container {\n    -webkit-column-width: 308px;\n}\n\n.settings-tab .help-block {\n    margin-left: 20px;\n}\n\n.settings-tab .field-error-message {\n    color: DarkRed;\n    height: 0; /* Avoid changing element height when content is set. */\n}\n\n.help-line {\n    padding-bottom: 5px;\n    margin-bottom: 5px;\n}\n\n.help-key-cell {\n    display: inline-block;\n    width: 153px;\n    white-space: nowrap;\n    text-align: right;\n    vertical-align: middle;\n    padding-right: 6px;\n}\n\n.help-cell {\n    display: inline-block;\n    width: 135px;\n    vertical-align: middle;\n}\n\n.help-section-title {\n    font-size: 120%;\n    text-align: left;\n}\n\n.help-key {\n    padding: 0.1em 0.6em;\n    border: 1px solid #ccc;\n    font-size: 11px;\n    background-color: #f7f7f7;\n    color: #333;\n    box-shadow: 0 1px 0 rgba(0, 0, 0, 0.2), 0 0 0 2px #ffffff inset;\n    border-radius: 3px;\n    display: inline-block;\n    margin: 0 0.1em;\n    text-shadow: 0 1px 0 #fff;\n    line-height: 1.5;\n    white-space: nowrap;\n    font-family: Lucida Grande, sans-serif;\n}\n\n.help-combine-keys,\n.help-key-delimiter {\n    font-size: 9px;\n}\n\n.help-combine-keys {\n    margin: 0 0.3em;\n}\n\n.help-key-delimiter {\n    margin: 0 0.5em;\n    display: none;\n}\n\nfieldset {\n    margin: 0;\n    padding: 0;\n    border: none;\n}\n\n.settings-tab label {\n    padding-right: 4px;\n    display: inline-flex;\n}\n\n#general-tab-content .help-block fieldset legend {\n    font-size: 14px;\n}\n\n.help-block p p {\n    padding-left: 30px;\n}\n\n.help-content p.help-section {\n    margin: 0 0 15px 0;\n}\n\n.settings-experiments-warning-subsection-warning {\n    color: rgb(200, 0, 0);\n}\n\n.settings-experiments-warning-subsection-message {\n    color: inherit;\n}\n\n.help-content input[type=checkbox] {\n    margin: 1px 7px 1px 2px;\n}\n\n.help-content option {\n    background-color: #EEEEEE;\n    color: #222;\n}\n\n.help-window-label {\n    font-size: 18px;\n    color: inherit;\n    padding: 1px 0 15px 17px;\n}\n\n.help-container-wrapper {\n    position: absolute;\n    top: 40px;\n    left: 0px;\n    right: 0;\n    bottom: 0;\n    overflow: auto;\n}\n\n.settings-tab.help-content {\n    margin: 0;\n    padding: 0;\n}\n\n.settings-tab input:not([type]),\n.settings-tab input[type=\"text\"] {\n    border: 1px solid rgb(213, 213, 213);\n    border-radius: 2px;\n    color: #444444;\n    padding: 3px;\n}\n\n.settings-tab input.numeric {\n    text-align: right;\n}\n\n.settings-tab-container {\n    flex: auto;\n    overflow: hidden;\n}\n\n.settings-tab-container header {\n    padding: 0 0 6px;\n    border-bottom: 1px solid #EEEEEE;\n}\n\n#experiments-tab-content .help-container {\n    -webkit-column-width: 470px;\n}\n\n#experiments-tab-content .help-block {\n    width: 470px;\n    margin-left: 0;\n}\n\n.settings-tab-container header > h3 {\n    font-size: 18px;\n    font-weight: normal;\n    margin: 0;\n    padding-bottom: 3px;\n}\n\n.settings-tab .help-section-title {\n    margin-left: -20px;\n    color: #222;\n}\n\n.settings-tab .help-block fieldset:disabled label:hover {\n    color: inherit;\n}\n\n.settings-tab .help-block label:hover {\n    color: #222;\n}\n\n.settings-tab p {\n    margin: 12px 0;\n}\n\n.settings-tab select {\n    margin-left: 10px;\n}\n\n#workspace-tab-content .settings-tab.help-content.help-container {\n    -webkit-column-width: initial;\n}\n\n\n#workspace-tab-content .button:hover {\n    opacity: 1.0 !important;\n}\n\n#workspace-tab-content .help-block {\n    width: auto;\n    margin-right: 20px;\n}\n\n.settings-tab .settings-list {\n    border: 1px solid hsl(0, 0%, 85%);\n    border-radius: 2px;\n}\n\n.settings-tab .settings-list .settings-list-item:not(.editable) {\n    background-color: #eee;\n}\n\n.excluded-folders-list .settings-list-item:not(.editable) .settings-list-column-path:before,\n.settings-list-item:not(.editable) .list-column.settings-list-column-url:before {\n    content: \"\\1F512\";\n    margin-right: 5px;\n}\n\n\n.settings-tab .settings-list .settings-list-item .settings-list-item-contents {\n    width: 100%;\n    height: 40px;\n    -webkit-box-align: center;\n    -webkit-transition: 150ms background-color;\n    display: -webkit-box;\n    padding-right: 8px;\n}\n\n.settings-tab .settings-list .settings-list-item .settings-list-item-contents > :first-child {\n    -webkit-box-align: center;\n    -webkit-box-flex: 1;\n    -webkit-padding-end: 5px;\n    display: -webkit-box;\n}\n\n.settings-tab .settings-list .settings-list-item.selected:not(.editable) {\n    background-color: hsl(0, 0%, 82%);\n}\n\n.settings-tab .settings-list .settings-list-item:hover {\n    background-color: hsl(215, 54%, 93%);\n}\n\n.settings-tab .settings-list .settings-list-item.selected:not(.editable):hover {\n    background-color: hsl(215, 51%, 82%);\n}\n\n.settings-tab .settings-list .settings-list-item .remove-item-button {\n    -webkit-transition: 150ms opacity;\n    background-color: hsla(0, 0%, 0%, 0);\n    background-image: -webkit-image-set(\n        url(Images/settingsListRemove.png) 1x,\n        url(Images/settingsListRemove_2x.png) 2x);\n    background-size: 48px 16px;\n    border: none;\n    display: block;\n    height: 16px;\n    width: 16px;\n    opacity: 0;\n    pointer-events: none;\n}\n\n.settings-tab .settings-list .settings-list-item.selected .remove-item-button,\n.settings-tab .settings-list .settings-list-item:hover .remove-item-button {\n    opacity: 1;\n    pointer-events: auto;\n}\n\n.settings-tab .settings-list .settings-list-item .remove-item-button:hover {\n    background-position-x: -32px;\n}\n\n.settings-tab .settings-list .settings-list-item .remove-item-button:active {\n    background-position-x: -16px;\n}\n\n.settings-list-item-columns {\n    height: 100%;\n}\n\n.settings-tab .settings-list .settings-list-item .list-column {\n    displaY: -webkit-box;\n    -webkit-box-align: center;\n    padding-left: 5px;\n    padding-right: 2px;\n    box-sizing: border-box;\n    overflow: hidden;\n    text-overflow: ellipsis;\n    height: 100%;\n}\n\n.settings-tab .settings-list .settings-list-item .list-column .list-column-editor {\n    width: 100%;\n}\n\n.settings-tab .settings-list .settings-list-item.add-list-item .remove-item-button {\n    visibility: hidden;\n}\n\n.settings-tab .settings-list .settings-list-item.editable .list-column .list-column-editor {\n    display: none;\n}\n\n.settings-tab .settings-list .settings-list-item.editable.item-editing .list-column .list-column-editor {\n    display: block;\n}\n\n.settings-tab .settings-list .settings-list-item.editable.item-editing .list-column .list-column-text {\n    display: none;\n}\n\n.settings-tab .settings-list .settings-list-item.editable.item-editing .list-column .list-column-editor.editable-item-error {\n    background-color: pink;\n}\n\ninput.list-column-editor {\n    border: 1px solid rgb(213, 213, 213);\n    border-radius: 2px;\n    color: #444444;\n    padding: 3px;\n}\nselect.list-column-editor {\n    padding: 2px;\n    margin-left: 0;\n}\n\n.settings-tab .file-system-container {\n    margin-bottom: 20px;\n}\n\n.settings-tab .file-system-header {\n    display: flex;\n    flex-direction: row;\n    align-items: baseline;\n}\n\n.settings-tab .file-system-path {\n    white-space: nowrap;\n    font-size: 1.4em;\n    padding-right: 5px;\n    -webkit-box-flex: 1;\n    color: hsl(210, 16%, 22%);\n    margin-bottom: 8px;\n    overflow: hidden;\n    flex: 0 1 auto;\n    margin-right: 5px;\n    text-overflow: ellipsis;\n}\n\n.settings-tab .file-system-path-name {\n    padding-right: 6px;\n    font-weight: bold;\n}\n\n.file-systems-list .settings-list-item .list-column.settings-list-column-path {\n    width: 100%;\n}\n\n.file-mappings-list .settings-list-item .list-column.settings-list-column-url {\n    width: 50%;\n}\n\n.file-mappings-list .settings-list-item .list-column.settings-list-column-path {\n    width: 50%;\n}\n\n.blackbox-patterns-list {\n    max-width: 700px;\n}\n\n.blackbox-patterns-list .settings-list-item .list-column.settings-list-column-pattern {\n    width: 80%;\n}\n\n.blackbox-patterns-list .settings-list-item .list-column.settings-list-column-value {\n    width: 20%;\n}\n\n.excluded-folders-header {\n    margin-top: 10px;\n}\n\n.excluded-folders-list .settings-list-item .list-column.settings-list-column-path {\n    width: 100%;\n}\n\n.settings-tab .settings-list .settings-list-item.disabled .settings-list-column-pattern .list-column-text {\n    color: #666;\n    text-decoration: line-through;\n}\n\n.settings-dialog {\n    display: -webkit-flex;\n    -webkit-flex-direction: column;\n}\n\n.settings-dialog .dialog-contents {\n    display: flex;\n    flex-direction: column;\n}\n\n.settings-dialog .header {\n    flex: 0 0 auto;\n    color: #333;\n    font-size: 14px;\n    margin: 0;\n    padding: 14px 17px 14px;\n}\n\n.settings-dialog .contents {\n    flex: 1 1 auto;\n    overflow-x: hidden;\n    overflow-y: auto;\n}\n\n.settings-dialog .block-header {\n    color: black;\n    font-size: 1.2em;\n    margin-bottom: 0.8em;\n}\n\n.blackbox-dialog .columns-header {\n    color: black;\n    font-weight: bold;\n    margin-bottom: 0.4em;\n    display: -webkit-box;\n    padding: 0;\n    max-width: 700px;\n}\n\n.blackbox-dialog .columns-header span {\n    width: 80%;\n    display: -webkit-box;\n}\n\n.blackbox-dialog .columns-header span + span {\n    margin-left: -17px;\n    width: 20%;\n}\n\n.blackbox-content-scripts {\n    padding: 0 0 14px 0;\n    margin-left: -4px;\n}\n\n.settings-dialog .done-button {\n    float: right;\n}\n\n.settings-glass-pane {\n    -webkit-box-align: center;\n    -webkit-box-orient: vertical;\n    -webkit-box-pack: center;\n    display: -webkit-box;\n    z-index: 2000 !important;\n    padding: 5px;\n    background-color: rgba(255, 255, 255, 0.4) !important;\n}\n\n.help-indent-labels label {\n    padding-left: 10px;\n}\n\n.dialog-contents .section {\n    min-width: 400px;\n}\n\n.settings-experiment-hidden {\n    display: none;\n}\n\n.settings-experiment-hidden label {\n    background-color: #ddd;\n}\n\n.settings-developer-mode .settings-experiment-hidden {\n    display: block;\n}\n\n/*# sourceURL=settings/settingsScreen.css */";